unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    Panel1: TPanel;
    imgKONIEC: TImage;
    imgDOIT: TImage;
    imgFIND: TImage;
    imgGET_FONTS: TImage;
    RichEdit1: TRichEdit;
    procedure imgGET_FONTSClick(Sender: TObject);
    procedure imgFINDClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure imgDOITClick(Sender: TObject);
    procedure imgKONIECClick(Sender: TObject);

  private

  public

  end;

var
  MainForm: TMainForm;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TMainForm.imgKONIECClick(Sender: TObject);
begin
	Close();
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
   RichEdit1.Clear();
   RichEdit1.Align := alClient;
   RichEdit1.Lines.LoadFromFile('eula.rtf');
end;

procedure TMainForm.imgDOITClick(Sender: TObject);
var
	kom : String;

begin
	kom :=  '';

   RichEdit1.Clear();

   kom := 'Linia nr 01';
   RichEdit1.SelAttributes.Name  :=  'Times New Roman';
   RichEdit1.SelAttributes.Size  :=  12;
   RichEdit1.SelAttributes.Color :=  clRed;
   RichEdit1.Lines.Add(kom);

   kom := 'Linia nr 02';
   RichEdit1.SelAttributes.Name  :=  'Garmond';
   RichEdit1.SelAttributes.Size  :=  14;
   RichEdit1.SelAttributes.Color :=  clBlue;
   RichEdit1.Lines.Add(kom);

   kom := 'Linia nr 03';
   RichEdit1.SelAttributes.Name  :=  'Arial CE';
   RichEdit1.SelAttributes.Size  :=  16;
   RichEdit1.SelAttributes.Color :=  clGreen;
   RichEdit1.Lines.Add(kom);

   kom := 'Linia nr 04';
   RichEdit1.SelAttributes.Name  :=  'Terminal';
   RichEdit1.SelAttributes.Size  :=  18;
   RichEdit1.SelAttributes.Color :=  clMaroon;
   RichEdit1.Lines.Add(kom);

   RichEdit1.SelAttributes.Color :=  clYellow;
   RichEdit1.SelStart  :=   8;
   RichEdit1.SelLength :=  15;
end;

procedure TMainForm.imgFINDClick(Sender: TObject);
var
   FoundAt  : Integer;
   StartPos : Integer;
   ToEnd    : Integer;
   txt      : String;
   st       : TSearchTypes;

begin
   FoundAt  :=  0;
   StartPos :=  0;
   ToEnd    :=  0;

   txt := InputBox('Okno dialogowe', 'Podaj tekst to odnalezienia', '');
   if txt = '' then
   begin
   	exit;
   end;

   // begin the search after the current selection
   // if there is one
   // otherwise, begin at the start of the text
   if RichEdit1.SelLength > 0 then
   begin
   	StartPos := RichEdit1.SelStart + RichEdit1.SelLength;
   end
   else begin
   	StartPos :=  0;

      // ToEnd is the length from StartPos
      // to the end of the text in the rich edit control
      ToEnd := Length(RichEdit1.Text) - StartPos;

		st := [stMatchCase];
      FoundAt := RichEdit1.FindText(txt, StartPos, ToEnd, st);

      if FoundAt <> -1 then
      begin
      	RichEdit1.SetFocus();
         RichEdit1.SelStart  := FoundAt;
         RichEdit1.SelLength := Length(txt);
      end;
   end;
end;

procedure TMainForm.imgGET_FONTSClick(Sender: TObject);
var
   lp : Integer;

begin
   RichEdit1.Clear();

   // lista zainstalowanych w systemie czcionek
   for lp := 0 to Screen.Fonts.Count-1 do
   begin
      RichEdit1.Lines.Add(Screen.Fonts.Strings[lp]);
   end;
end;

end.

